function [CorrFunc,Lag] = CrossAlign(Signal,Kernel)

SizeY      = size(Signal,1);
SizeX      = size(Signal,2);
if mod(SizeX,2)
    Signal = [Signal,Signal(:,end)];
    Kernel = [Kernel,Kernel(:,end)];
    SizeX  = SizeX + 1;
    A      = 1;
else
    A      = 0;
end
ZeroPad    = zeros([SizeY,SizeX./2]);

Signal     = [ZeroPad,Signal,ZeroPad];
Kernel     = [ZeroPad(1,:),Kernel,ZeroPad(1,:)];
Signal     = Signal(:,1:end-1);
Kernel     = Kernel(:,1:end-1);

SizeCorr   = SizeX*2-1;
Signal     = Signal./sum(Signal,2);
Kernel     = Kernel./sum(Kernel,2);
Kernel     = repmat(Kernel,[1,SizeY]);
Kernel     = fft(Kernel,SizeCorr,2);

Signal     = fft(Signal,SizeCorr,2);

CrossCorr  = conj(Kernel).*Signal;
CrossCorr  = ifft(CrossCorr,[],2);

CorrFunc   = ifftshift(CrossCorr,2);

if A==1
    Lag        = - SizeX/2+1:SizeX/2-1;
    CorrFunc   = CorrFunc(:,1+SizeX/2+1:SizeX+1+SizeX/2-1);
else
    Lag        = - SizeX/2:SizeX/2;
    CorrFunc   = CorrFunc(:,1+SizeX/2:SizeX+1+SizeX/2);
end

clearvars -except CorrFunc Lag
end